/////////////////////////////////////// 
// Combat Rescue Mission
///////////////////////////////////////

function StartCombat::onEnter()
{
   // Turn on Behavior
   $AI_MONITORJOB     = false;
   $AI_MONITORHOME    = false;
   $AI_MONITORHUNGER  = false;
   GameCamera.FlySpeed = 75;
   
   TaskModifier.StrMarkVertex("CombatTask", "StartCombat", $TSV_CMPLETE);
   TaskModifier.StrMarkVertex("CombatTask", "blockedpassage", $TSV_AVAIL);
   TaskModifier.StrMarkVertex("CombatTask", "banditcampzone", $TSV_AVAIL);
   TaskModifier.StrMarkVertex("CombatTask", "CombatDefeatBandits", $TSV_AVAIL);
   TaskModifier.StrMarkVertex("CombatTask", "Cliffzone", $TSV_AVAIL);
   
   //Lock Build Command
   tsEnableCommand(BuildCmdData, false);
   
   //Name Civilians
   %char1obj = tsCreateObj("femaleciv", "civ1", "0", "-332 -160", "civ1");   
   %char1obj.name ="Pamela Lindsay";
   tsSkinObj("civ1", "default");
   %char2obj = tsCreateObj("maleciv", "civ2", "0", "-336 -155", "civ2");  
   %char2obj.name ="Alexander Luther";
   tsSkinObj("civ2", "default");
   %char3obj = tsCreateObj("femaleciv", "civ3", "0", "-330 -153", "civ3");  
   %char3obj.name = "Emma Francis";
   tsSkinObj("civ3", "default");
   
   %dlgData1 = tsCreateTaskDlgData("ID_Combat", false, false, "ID_CombatIntro");
   tsAddTaskDialog("ID_CombatIntro", %dlgData1);
   tsSendTaskDlgMsg(%dlgData1, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData1);
   
   // Quest log
   tsAddQuestToTracker(true, "Rescue Hope River Refugees", "", "Track down the bandits and rescue the captured Hope River citizens.", "Reward: 20 Experience");
   tsReadyQuest("Rescue Hope River Refugees");
   tsAddTaskToTracker("Rescue Hope River Refugees", "Rescue the Hope River Refugees.", "Find the Citizens and defeat the Bandits that are holding them.");
}
function TaskIntro::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   if(%this.isMarkedComplete())
   {  
      // Get id of character that triggered zone
      %objlist = tsGetObjListFromMsg(%msg, %params);
      %charID = %objlist.getID(0);
      // Shop keep asking for help
      %dlgData = tsCreateTaskDlgData("ID_Combat", false, $TaskButton::More);
      tsAddTaskDialog("ID_CombatHelp", %dlgData);
      tsSendTaskDlgMsg(%dlgData, shopkeep.getId());
      tsDestroyTaskDlgData(%dlgData);
      // Combat Unit asking directions
      %dlgData = tsCreateTaskDlgData("ID_Combat", false, $TaskButton::More, "ID_CombatHelp2");
      tsAddTaskDialog("ID_CombatHelp2", %dlgData);
      tsSendTaskDlgMsg(%dlgData, %charID);
      tsDestroyTaskDlgData(%dlgData);
      // Shop keep answer
      %dlgData = tsCreateTaskDlgData("ID_Combat", false, $TaskButton::More, "ID_Combatdirect");
      tsAddTaskDialog("ID_Combatdirect", %dlgData);
      tsSendTaskDlgMsg(%dlgData, shopkeep.getId());
      tsDestroyTaskDlgData(%dlgData);
      // Hero Speak
      %dlgData = tsCreateTaskDlgData("ID_Combat", false, false, "ID_herotext1");
      tsAddTaskDialog("ID_herotext1", %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      
      //Quest log
      tsAddQuestToTracker(false, "General Help", "", "The shopkeeper needs help tracking down the Bandits that stole his goods and locked him out of his store.", "Reward: Unknown");
      tsReadyQuest("General Help");
      tsAddTaskToTracker("General Help", "Recover the shopkeeper's goods.", "Track down the Bandits and recover the shopkeeper's goods and key.");
      tsAddTaskToTracker("General Help", "Defeat the thieving Bandits.", "Defeat the Bandits that attacked the shopkeeper.");
      
   }
}
function keycamptext::onMessage(%this, %msg, %params)
{
   // Get id of character that triggered zone
   Parent::onMessage(%this, %msg, %params);
   if(%this.isMarkedComplete())
   {
      %objlist = tsGetObjListFromMsg(%msg, %params);
      %charID = %objlist.getID(0);
   
      %dlgData = tsCreateTaskDlgData("ID_Combat", false, $TaskButton::More);
      tsAddTaskDialog("ID_Combatkey1", %dlgData);
      tsSendTaskDlgMsg(%dlgData, thief1.getId());
      tsDestroyTaskDlgData(%dlgData);
      %dlgData1 = tsCreateTaskDlgData("ID_Combat", false, $TaskButton::More);
      tsAddTaskDialog("ID_Combatkey2", %dlgData1);
      tsSendTaskDlgMsg(%dlgData1, thief2.getId());
      tsDestroyTaskDlgData(%dlgData1);
      %dlgData2 = tsCreateTaskDlgData("ID_Combat", false, false);
      tsAddTaskDialog("ID_Combatkey3", %dlgData2);
      tsSendTaskDlgMsg(%dlgData2, %charID);
      tsDestroyTaskDlgData(%dlgData2);
      TaskModifier.strMarkVertex("CombatTask", "keycamptext", $TSV_CMPLETE);
      
      // Move Bandits into combat range
      tsMoveObjToTarget("thief1", "-195 -323");
      tsMoveObjToTarget("thief2", "-194 -321");
   }
}
// Triggers when enter zone dynamitezone
function Cliffzone::onMessage(%this, %msg, %params)
{
   // Get id of character that triggered zone
   Parent::onMessage(%this, %msg, %params);
   if(%this.isMarkedComplete())
   {
      %objlist = tsGetObjListFromMsg(%msg, %params);
      %charID = %objlist.getID(0);
      tsSendTaskPopUpDlg("ID_Combat", "ID_cliffzone", $TaskButton::Okay, %charID, "ID_cliffzone");
   }
}
function CombatDefeatThief::onExit()
{
   %dlgData = tsCreateTaskDlgData("ID_Combat", false, false);
   tsAddTaskDialog("ID_CombatTreasure", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   
   // Quest log
   tsCompleteTaskInTracker("General Help", "Defeat the thieving Bandits.");
      
}
// Triggers on zone: treasurezone
function treasurechest::onExit(%this)
{
   Parent::onExit(%this);
   // Get id of character that triggered zone
   %teamList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %count = 0;
   for(%index = 0; %index < %teamList.getSize(); %index++)
   {
      %charID = %teamList.getID(%index);
      if(%charID.isInZone(treasurezone))
      {
         %count++;
         break;
      }
   }
   if(%count == 0){
      %charID = "herocharacter";
   }
   tsDestroyObjList(%teamList);
   
   %dlgData = tsCreateTaskDlgData("ID_Combat", false, false, "ID_treasuredig");
   tsAddTaskDialog("ID_treasuredig", %dlgData);
   tsSendTaskDlgMsg(%dlgData, %charID);
   tsDestroyTaskDlgData(%dlgData);
}
function treasureDig::onExit()
{
   %treasurechest = tsCreateObj("chest", "keychest", $OST_NEUTRAL, "-172 -304", "keychest");
   %treasuretnt1 = tsCreateObj("Dynamite", "tnt1", $OST_NEUTRAL, "-171 -306", "tnt1");
   %treasuretnt2 = tsCreateObj("Dynamite", "tnt2", $OST_NEUTRAL, "-173 -306", "tnt2");
   %dlgData = tsCreateTaskDlgData("ID_Combat", false, false);
   tsAddTaskDialog("ID_Combatfind", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
}
function chestpickup::onExit()
{
   tsRemoveObj(tnt1);
   tsRemoveObj(tnt2);
   %dlgData = tsCreateTaskDlgData("ID_Combat", false, false, "ID_chestpickup");
   tsAddTaskDialog("ID_chestpickup", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   
   //Quest log
   tsAddTaskToTracker("General Help", "Return to the Store.", "Return the stolen goods to the General Store.");
   tsCompleteTaskInTracker("General Help", "Recover the shopkeeper's goods.");
}
function returntostore::onExit()
{
   
   tsSendTaskPopUpDlg("ID_Combat", "id_tntstorecomplete", $TaskButton::Okay, "shopkeep");
   
   //Quest log
   tsCompleteTaskInTracker("General Help", "Return to the Store.");
   // Start Wood for Gold Task      
   TaskModifier.strMarkVertex("CombatTask", "tradeforgoldstart", $TSV_AVAIL);
   
}
//////////////////////////////////////////////////////////////////////////////
//Sell Wood for Gold at the GeneralStore
//Mini task that allows the player to trade wood for gold at the general store.
//////////////////////////////////////////////////////////////////////////////
function tradeforgoldstart::onEnter()
{
   %dlgData = tsCreateTaskDlgData("ID_Combat", true, false, "ID_woodtrade");
   tsAddTaskDialog("ID_woodtrade", %dlgData);
   tsSendTaskDlgMsg(%dlgData, shopkeep.getId());
   tsDestroyTaskDlgData(%dlgData);
}
function tradeforgold::onEnter()
{
   %dlgData = tsCreateTaskDlgData("ID_CombatSellWood", true, true, "ID_woodtradesale" );
   tsAddTaskDialog("ID_woodtradesale", %dlgData);
   tsAddAcceptCost($Resource::Wood, 80, %dlgData);
   tsSendTaskDlgMsg(%dlgData, shopkeep.getId());
   tsDestroyTaskDlgData(%dlgData);
   
   TaskModifier.strMarkVertex("CombatTask", "buydynamite", $TSV_AVAIL);
}
function soldwood::onEnter()
{
   tsModifyResource($Resource::Gold, 100, true);
   schedule(150, 0, "ResetTradeForGold");
}

function ResetTradeForGold()
{
   TaskModifier.strResetVertex("CombatTask", "tradeforgold");
   TaskModifier.strMarkVertex("CombatTask", "tradeforgold", $TSV_AVAIL);
}
//////////////////////////////////////////////////////////////////////////////
//Buy Dynamite at the GeneralStore
//Allows the player to trade 100 gold for 1 Dynamite 
//////////////////////////////////////////////////////////////////////////////

function buydynamite::onEnter()
{
   %dlgData = tsCreateTaskDlgData("ID_CombatTNT", true, true, "ID_buydynamite");
   tsAddTaskDialog("ID_buydynamite", %dlgData);
   tsAddAcceptCost($Resource::Gold, 100, %dlgData);
   tsSendTaskDlgMsg(%dlgData, shopkeep.getId());
   tsDestroyTaskDlgData(%dlgData);
}
function solddynamite::onEnter()
{
   //Increase players Dynamite count by 1
   %slot = invGetSlotForItem(ClientGroup.getObject( 0 ), $INV_DYNAMITE);
   if(%slot >= 0 )
   {
      if(invCanPushItem(ClientGroup.getObject( 0 ), %slot))
      {
         invPushItemInInventory(ClientGroup.getObject( 0 ), %slot);
      }
   }
   
   schedule(150, 0, "Resetbuydynamite");
}

function Resetbuydynamite()
{
   TaskModifier.strResetVertex("CombatTask", "buydynamite");
   TaskModifier.strMarkVertex("CombatTask", "buydynamite", $TSV_AVAIL);
}

//////////////////////////////////////////////////////////////////////////////
//Defeat Bandits Guarding Townsfolk
//////////////////////////////////////////////////////////////////////////////
// Trigger banditcampzone
function banditcampzone::onExit(%this)
{
  tsSendTaskPopUpDlg("ID_Combat", "ID_combathelp3", $TaskButton::More, "civ1", "ID_combathelp3");
  tsSendTaskPopUpDlg("ID_Combat", "ID_bandithelp", $TaskButton::Okay, "bandit2", "ID_bandithelp");   
}
// Short delay after defeating the bandits at the camp
function CombatDefeatBandits::onExit(%this)
{
   TaskModifier.StrMarkVertex("CombatTask", "CombatDefeatBanditdelay", $TSV_AVAIL);
}
function CombatDefeatBanditdelay::onExit(%this)
{
   tsSendTaskPopUpDlg("ID_Combat", "ID_combatrescue1", $TaskButton::More, "civ1", "ID_combatrescue1");
   tsSendTaskPopUpDlg("ID_Combat", "ID_combatrescue2", $TaskButton::More, "civ2", "ID_combatrescue2");
   tsSendTaskPopUpDlg("ID_Combat", "ID_combatrescuehero", $TaskButton::More, "HeroCharacter", "ID_combatrescuehero");
   tsSendTaskPopUpDlg("ID_Combat", "ID_combatwait", $TaskButton::Okay, "civ3", "ID_combatwait");
}
// Move Units to south road sign
function Combatmovewait::onExit(%this)
{
   tsMoveObjToTarget("civ3", exitsign.getID());
   tsMoveObjToTarget("civ2", "-290 -103");
   tsMoveObjToTarget("civ1", "-293 -108");
   
   %dialog = tsCreateTaskDlgData("ID_Combat", true, true, "ID_combatreturn");
   tsAddTaskDialog("ID_combatreturn", %dialog);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dialog);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dialog);
   tsSendTaskDlgMsg(%dialog, "civ3");
   tsDestroyTaskDlgData(%dialog);
}
// Returns to Mainmap
function HopeRiverRescueExit::onExit(%this)
{
   Parent::onExit(%this);
   %scenario  = new SLScenario() 
   {
      stack   = false;
      
      // carry back neutral gunslingers
      neutralGunslinger = true;
   };
   LoadScenario(%scenario, endHopeRescueTasks, winHopeRescueTasks);
   
   // complete the hope river satellite
   mapsatellite_hoperescue.disabled = false;
}

////////////////////////////////////////////////////////////////////////////////
//! Cleans up any left-over tasks
////////////////////////////////////////////////////////////////////////////////
function endHopeRescueTasks()
{
   tsEndTask("CombatTask");
}

////////////////////////////////////////////////////////////////////////////////
//! Rewards the player for mission completion and cleans the mission tasks upon
//! exit
////////////////////////////////////////////////////////////////////////////////
function winHopeRescueTasks()
{
   
   $AI_MONITORJOB     = true;
   $AI_MONITORHOME    = true;
   $AI_MONITORHUNGER  = true;   
   //Reward   
   tsModifyResource($Resource::Experience, 20, true);
   SendProductionToClient(HeroCharacter, "20 experience");
   
   TaskModifier.strMarkVertex("MainmapTasks", "HopeRescueComplete", $TSV_AVAIL);
}
// Lose 
function HopeRiverRescueLose::onUpdate(%this)
{
   Parent::onUpdate(%this);
   
   if(HeroCharacter.isHealing && !tsCombatUnitsExist($OST_PLAYER)) {
      tsRestartScenario();
   }
}

//////////////////////////////////////////////////////////////////////////////
//Trapped Gunslingers: 
//////////////////////////////////////////////////////////////////////////////
// Trigger dynamitezone
function blockedpassage::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   if(%this.isMarkedComplete())
   {  
      // Get id of character that triggered zone
      %objlist = tsGetObjListFromMsg(%msg, %params);
      %charID = %objlist.getID(0);
      tsSendTaskPopUpDlg("ID_Combat", "ID_combatbarricade", $TaskButton::Okay, %charID, "ID_combatbarricade");
      TaskModifier.StrMarkVertex("CombatTask", "openpassage", $TSV_AVAIL);
      
      %gun1obj = tsCreateObj("Malegunslinger", "gunslingertrap", "0", "0 0", "gunslingertrap");
      %gun1obj.name = "Yance Aiden";
   }
}
// Trigger zone on the other side of the fence
function openpassage::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   if(%this.isMarkedComplete())
   {  
      // Get id of character that triggered zone
      %objlist = tsGetObjListFromMsg(%msg, %params);
      %charID = %objlist.getID(0);
      tsSendTaskPopUpDlg("ID_Combat", "ID_combatotherside", $TaskButton::More, %charID, "ID_combatotherside");
      tsSendTaskPopUpDlg("ID_Combat", "ID_combatgunslingerhelp", $TaskButton::More, "gunslingertrap", "ID_combatgunslingerhelp");
      tsSendTaskPopUpDlg("ID_Combat", "ID_combatgunslingerokay", $TaskButton::More, %charID, "ID_combatgunslingerokay");
      tsSendTaskPopUpDlg("ID_Combat", "ID_combatgunslingerdynamite", $TaskButton::Okay, "gunslingertrap", "ID_combatgunslingerdynamite");
      
      TaskModifier.strMarkVertex("CombatTask", "Combatdestroybarricade", $TSV_AVAIL);
      TaskModifier.strMarkVertex("CombatTask", "Combatdestroycabin", $TSV_AVAIL);
      
      //Quest log
      tsAddQuestToTracker(false, "Dangerous Rescue", "", "Two gunslingers have been barricaded inside an old Cabin. Place Dynamite far enough in front of the makeshift barricade so the Cabin isn't destroyed.", "Reward: 5 Experience and 2 additional Gunslingers");
      tsReadyQuest("Dangerous Rescue");
      tsAddTaskToTracker("Dangerous Rescue", "Free the trapped Gunslingers.", "Free the trapped Gunslingers by destroying the barricade with Dynamite.");
   
   }
}
/////////////////////////////////////
// Destroy barrel barricade
/////////////////////////////////////
function Combatdestroybarricade::onExit(%this)
{
   TaskModifier.strMarkVertex("CombatTask", "DestroybarricadeCheck", $TSV_AVAIL);
   // remove dialog gunslinger   
   gunslingertrap.deleteObject();
}
function DestroybarricadeCheck::onExit(%this)
{
   //Check to see if cabin was destroyed
   if(!(Combatdestroycabin.isMarkedComplete() || Combatdestroycabin.isComplete()))
   {
      // spawn happy gunslingers
      %gun1obj = tsCreateObj("Malegunslinger", "gun1", "1", "-395 -302", "gun1");
      %gun2obj = tsCreateObj("Femalegunslinger", "gun2", "1", "-400 -300", "gun2");
      %gun1obj.name = "Yance Aiden";
      %gun2obj.name = "Elvira Helpenhal";
      
      TaskModifier.strMarkVertex("CombatTask", "destroybarricadedelay", $TSV_AVAIL); 
   }
   
}
function destroybarricadedelay::onExit(%this)
{
   tsSendTaskPopUpDlg("ID_Combat", "ID_combatgunfree", $TaskButton::Okay, "gun1", "ID_combatgunfree");
   TaskModifier.strMarkVertex("CombatTask", "Combatdestroycabin", $TSV_CLOSED);
   //quest log
   tsCompleteTaskInTracker("Dangerous Rescue", "Free the trapped Gunslingers.");
   //reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(HeroCharacter, "5 experience");
}

/////////////////////////////////////
// Destroy cabin
/////////////////////////////////////
function Combatdestroycabin::onExit(%this)
{
   TaskModifier.strMarkVertex("CombatTask", "DestroyCabinCheck", $TSV_AVAIL);
}
function DestroyCabinCheck::onExit(%this)
{
   if(!(destroybarricadedelay.isMarkedComplete() || destroybarricadedelay.isComplete()))
   {
      // spawn unhappy gunslingers
      %gun1obj = tsCreateObj("Malegunslinger", "madgun1", "0", "-395 -308", "madgun1");
      %gun2obj = tsCreateObj("Femalegunslinger", "madgun2", "0", "-400 -306", "madgun2");
      %gun1obj.name = "Yance Aiden";
      %gun2obj.name = "Elvira Helpenhal";
      
      TaskModifier.strMarkVertex("CombatTask", "destroycabindelay", $TSV_AVAIL);
   }
}
function destroycabindelay::onExit(%this)
{
   tsSendTaskPopUpDlg("ID_Combat", "ID_combatcabindestroy", $TaskButton::Okay, "madgun1", "ID_combatcabindestroy");
   TaskModifier.strMarkVertex("CombatTask", "Combatdestroybarricade", $TSV_CLOSED);
}